<?php
// use Namespaces for HTTP request
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;

// create new Slim instance
$app = new \Slim\App;


// create GET HTTP request
/**
 * Get All Customers
 */
$app->get('/api/customers', function( Request $request, Response $response){
  // echo 'Sawandee my customers';

  $sql = "SELECT * FROM customers";

  try {
    // Get DB Object
    $db = new db();

    // connect to DB
    $db = $db->connect();

    // query
    $stmt = $db->query( $sql );
    $customers = $stmt->fetchAll( PDO::FETCH_OBJ );
    $db = null; // clear db object

    // return the result as json format
    echo json_encode( $customers );    


  } catch( PDOException $e ) {

    // return error message as Json format
    echo '{"error": {"msg": ' . $e->getMessage() . '}';
  }

});



/**
 * Get Single Customer
 */
// create GET HTTP request
$app->get('/api/customer/{id}', function( Request $request, Response $response){
  $id = $request->getAttribute('id');

  $sql = "SELECT * FROM customers WHERE id = $id";

  try {
    // Get DB Object
    $db = new db();

    // connect to DB
    $db = $db->connect();

    // query
    $stmt = $db->query( $sql );
    $customer = $stmt->fetchAll( PDO::FETCH_OBJ );
    $db = null; // clear db object

    // return the result as json format
    echo json_encode( $customer );    

    
  } catch( PDOException $e ) {

    // return error message as Json format
    echo '{"error": {"msg": ' . $e->getMessage() . '}';
  }

});



/**
 * Add new customer data
 */
// create POST HTTP request
$app->post('/api/customer/add', function( Request $request, Response $response){

  // get the parameter from the form submit
  $name = $request->getParam('name');
  $address = $request->getParam('address');
  

  $sql = "INSERT INTO customers (name,address) VALUES(:name,:address)";

  try {
    // Get DB Object
    $db = new db();

    // connect to DB
    $db = $db->connect();

    // https://www.php.net/manual/en/pdo.prepare.php
    $stmt = $db->prepare( $sql );

    // bind each paramenter
    // https://www.php.net/manual/en/pdostatement.bindparam.php
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':address', $address);

    // execute sql
    $stmt->execute();
    
    // return the message as json format
    echo '{"notice" : {"msg" : "New Customer Added.."}';

  } catch( PDOException $e ) {

    // return error message as Json format
    echo '{"error": {"msg": ' . $e->getMessage() . '}';
  }

});



/**
 * Update a Single Customer data
 */
// create PUT HTTP request
$app->put('/api/customer/update/{id}', function( Request $request, Response $response){
  // get attribute from URL
  $id = $request->getAttribute('id');
  
  // get the parameter from the form submit
  $name = $request->getParam('name');
  $address = $request->getParam('address');
  
  $sql = "UPDATE customers SET 
          name = :name,
          address = :address 
          WHERE id = $id";

  try {
    // Get DB Object
    $db = new db();

    // connect to DB
    $db = $db->connect();

    // https://www.php.net/manual/en/pdo.prepare.php
    $stmt = $db->prepare( $sql );

    // bind each paramenter
    // https://www.php.net/manual/en/pdostatement.bindparam.php
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':address', $address);

    // execute sql
    $stmt->execute();
    
    // return the message as json format
    echo '{"notice" : {"msg" : "New Customer Updated.."}';

  } catch( PDOException $e ) {

    // return error message as Json format
    echo '{"error": {"msg": ' . $e->getMessage() . '}';
  }

});



/**
 * Delete a Single Customer data
 */
// create DELETE HTTP request
$app->delete('/api/customer/delete/{id}', function( Request $request, Response $response){
  // get attribute from URL
  $id = $request->getAttribute('id');   

  $sql = "DELETE FROM customers WHERE id = $id";

  try {
    // Get DB Object
    $db = new db();

    // connect to DB
    $db = $db->connect();

    $stmt = $db->prepare($sql);  

    // execute sql
    $stmt->execute();
    $db = null;
    
    // return the message as json format
    echo '{"notice" : {"msg" : "New Customer Deleted.."}';

  } catch( PDOException $e ) {

    // return error message as Json format
    echo '{"error": {"msg": ' . $e->getMessage() . '}';
  }

});