<?php

/**
 * The archive template file
 * 
 * Copy code from the index file from TwentyTwenty theme
 * Learn more about hierarchy template:
 * https://developer.wordpress.org/files/2014/10/Screenshot-2019-01-23-00.20.04.png
 */

get_header();
?>
<main id="site-content" role="main">

    <?php
    // # query the custom field value
    $loop = new WP_Query(array('post_type' => 'mms_project_cpt', 'posts_per_page' => 10));

    while ($loop->have_posts()) : $loop->the_post();
    ?>

        <article <?php post_class(); ?> id="post-<?php the_ID(); ?>">

            <!-- # display the title -->
            <header class="entry-header has-text-align-center">
                <div class="entry-header-inner section-inner medium">
                    <?php the_title('<h2 class="entry-title heading-size-1"><a href="' . esc_url(get_permalink()) . '">', '</a></h2>'); ?>
                </div>
            </header>

            <div class="post-inner <?php echo is_page_template('templates/template-full-width.php') ? '' : 'thin'; ?> ">

                <div class="entry-content" data-rinquest="<?php echo get_the_ID() ?>">

                    <?php
                    // # get the current post ID
                    $post_id = get_the_ID();

                    // # check empty value
                    if (!empty($post_id)) {

                        // # retrieve the custom field value
                        // https://developer.wordpress.org/reference/functions/get_post_type/
                        $proj_image = get_post_meta($post_id, '_proj-image', true);
                        $proj_desc = get_post_meta($post_id, '_proj-desc', true);
                        $proj_days = get_post_meta($post_id, '_proj-days', true);
                        $proj_website = get_post_meta($post_id, '_proj-website', true);
                        $proj_published = get_post_meta($post_id, '_proj-published', true);


                        // # securing output
                        // https://developer.wordpress.org/themes/theme-security/data-sanitization-escaping/#escaping-securing-output
                        if (!empty($proj_image))
                            $proj_image = esc_url($proj_image);

                        if (!empty($proj_desc))
                            $proj_desc = esc_textarea($proj_desc);

                        if (!empty($proj_days))
                            $proj_days = esc_html($proj_days);

                        if (!empty($proj_website))
                            $proj_website = esc_url($proj_website);

                        if (!empty($proj_published))
                            $proj_published = esc_html($proj_published);


                        // # display the custom field value
                        // project image
                        echo '<p><b>' . __('Project Image', 'your-textdomain') . ': </b></p>';
                        echo '<p padding: 10px;">' . '<img src="' . $proj_image . '" alt="" style="max-width:100%; border:1px solid #dddddd;">' . '</p>';
                        // project description
                        echo '<p><b>' . __('Project Description', 'your-textdomain') . ': </b></p>';
                        echo '<p style="background:#ffffff; padding: 10px;">' . $proj_desc . '</p>';
                        // days
                        echo '<p><b>' . __('Time spent on the project ', 'your-textdomain') . ': </b></p>';
                        echo '<p style="background:#ffffff; padding: 10px;">' . $proj_days . '</p>';
                        // website
                        echo '<p><b>' . __('Website', 'your-textdomain') . ': </b></p>';
                        echo '<p style="background:#ffffff; padding: 10px;">' . $proj_website . '</p>';
                        // published date
                        echo '<p><b>' . __('Published date', 'your-textdomain') . ': </b></p>';
                        echo '<p style="background:#ffffff; padding: 10px;">' . $proj_published . '</p>';

                        echo '<hr>';
                        echo '<br><br>';
                    }
                    ?>

                </div><!-- .entry-content -->

            </div><!-- .post-inner -->

        </article> <!-- .mms_project_cpt -->

    <?php endwhile; ?>

    <!-- Destroys the previous query and sets up a new query. -->
    <!-- https://developer.wordpress.org/reference/functions/wp_reset_query/ -->
    <?php wp_reset_query(); ?>


</main><!-- #site-content -->

<?php get_template_part('template-parts/footer-menus-widgets'); ?>

<?php
get_footer();
