// # Javascript Reference/wp-media
// https://codex.wordpress.org/Javascript_Reference/wp.media
jQuery(function ($) {
    $('body').on('click', '.wpar_upload_image_button', function (e) {
        e.preventDefault();

        var button = $(this),
            wpar_uploader = wp.media({
                title: 'Custom image',
                library: {
                    // # We scope to display the images that attach to our post ID only.
                    // You can remove the uploadedTo option if you want to display all images from the media library.
                    // uploadedTo: wp.media.view.settings.post.id,

                    // # You can change the file type to display. The file type is the same as Media Library support.
                    // For example, you can set the type as
                    // type: [ 'video', 'image' ]
                    type: 'image'
                },
                button: {
                    text: 'Use this image'
                },
                multiple: false
            }).on('select', function () {
                var attachment = wpar_uploader.state().get('selection').first().toJSON();

                // # Change the #proj-image to your input ID
                $('#proj-image').val(attachment.url);
            })
                .open();
    });
});