<?php

/**
 * include the parent theme style
 */
add_action('wp_enqueue_scripts', 'my_theme_enqueue_styles');
function my_theme_enqueue_styles()
{
    $parenthandle = 'parent-style'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.
    $theme = wp_get_theme();
    wp_enqueue_style(
        $parenthandle,
        get_template_directory_uri() . '/style.css',
        array(),  // if the parent theme code has a dependency, copy it to here
        $theme->parent()->get('Version')
    );
    wp_enqueue_style(
        'child-style',
        get_stylesheet_uri(),
        array($parenthandle),
        $theme->get('Version') // this only works if you have Version in the style header
    );
}

/**
 * ## Strongly recommend to add the custom post type and custom taxonomy in your own plugin rather than functions.php.
 * ## Because if you change the theme, the stored content will be disappear since the snippet code is in the functions.php.
 * Create custom post type names "mms_project_cpt"
 * Create custom taxonomy names "keyword_project_cpt"
 */
// # custom post type
add_action('init', 'project_post_type');
// # custom taxonomy
// add_action('init', 'project_keyword');

function project_post_type()
{
    // custom post type name is 20 maximum.
    register_post_type(
        'mms_project_cpt',
        array(
            'labels' => array(
                'name' => __('Projects', 'your-textdomain'),
                'singular_name' => __('Project', 'your-textdomain'),
                'add_new' => __('Add New Project', 'your-textdomain'),
                'add_new_item' => __('Add New Project', 'your-textdomain'),
                'edit' => __('Edit', 'your-textdomain'),
                'edit_item' => __('Edit Project', 'your-textdomain'),
                'new_item' => __('New Project', 'your-textdomain'),
                'view' => __('View', 'your-textdomain'),
                'view_item' => __('View Project', 'your-textdomain'),
                'search_items' => __('Search Project', 'your-textdomain'),
                'not_found' => __('No Project found', 'your-textdomain'),
                'not_found_in_trash' => __('No Project found in Trash', 'your-textdomain'),
            ),
            'public' => true,
            'show_ui' => true,
            'menu_position' => 2,
            'supports' => array('title'),
            'rewrite' => array('slug' => __('projects', 'your-textdomain')),
            'has_archive' => true,
            'menu_icon' => 'dashicons-superhero'
        )
    );
}

function project_keyword()
{
    $labels = array(
        'name' => 'Keywords',
        'singular_name' => 'Keyword',
        'search_items' =>  __('Search Keywords'),
        'all_items' => __('All Keywords'),
        'parent_item' => __('Parent Keyword'),
        'parent_item_colon' => __('Parent Keyword:'),
        'edit_item' => __('Edit Keyword'),
        'update_item' => __('Update Keyword'),
        'add_new_item' => __('Add New Keyword'),
        'new_item_name' => __('New Keyword'),
        'menu_name' => __('Keywords'),
        'not_found' => __('No Keywords found')
    );

    register_taxonomy(
        'keyword_project_cpt',  // The name of the taxonomy. Name should be in slug form (must not contain capital letters or spaces).
        'mms_project_cpt',  // post type name
        array(
            'hierarchical' => false,
            'labels' => $labels,
            'show_ui' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'keyword'),
        )
    );
}

// # Add the custom fields to the admin page.
// # Note for a quick edit, if you want to use the quick edit with the custom fields, you must display the post title at the admin panel.
// Because the quick edit feature attaches to the post title ONLY.
// add_filter('manage_project_cpt_posts_columns', 'add_wpar_columns');
function add_wpar_columns($columns)
{
    $columns = array(
        'cb' => $columns['cb'],
        'title' => __('Title', 'your-textdomain'),
        'author' => __('Author'),
        'date' => __('Date'),
    );
    return $columns;
}



// # doc
// https://developer.wordpress.org/reference/functions/add_meta_box/

/**
 * Register meta box(es).
 */
function wpar_register_meta_boxes()
{
    add_meta_box('proj-fields-group', __('Project Meta Box', 'your-textdomain'), 'wpar_my_display_callback', 'mms_project_cpt');
}
add_action('add_meta_boxes', 'wpar_register_meta_boxes');


/**
 * Customize WordPress media uploader for our project post type
 * You want to customize the media uploader code from the link to meet your need.
 * https://codex.wordpress.org/Javascript_Reference/wp.media
 */
function wpar_include_script()
{

    if (!did_action('wp_enqueue_media')) {
        wp_enqueue_media();
    }

    wp_enqueue_script('wpar_proj-img_uploader', get_stylesheet_directory_uri() . '/js/project_img_uploader.js', array('jquery'), null, false);
}
add_action('admin_enqueue_scripts', 'wpar_include_script');


/**
 * Meta box display callback.
 *
 * @param WP_Post $post Current post object.
 */
function wpar_my_display_callback($post)
{
    // # Display code/markup goes here. Don't forget to include nonces!

    // https://developer.wordpress.org/reference/functions/wp_nonce_field/
    // We will check the nonce when we are saving the field value.
    wp_nonce_field(basename(__FILE__), 'wpar_project_nonce');


    // # Display all custom fileds
    echo '<table>';

    // 1.project image field
    echo '<tr>';
    echo '<td style="vertical-align: top; background: #f6f6f6; padding: 5px 10px;">';
    echo '<a href="#" class="button button-secondary wpar_upload_image_button">' . __('Upload Image', 'your-textdomain') . '</a>';
    echo '</td>';
    echo '<td>';
    $proj_image = get_post_meta($post->ID, '_proj-image', true);
    echo '<input type="text" id="proj-image" name="proj-image" style="width:100%;" readonly="readonly">';
    echo '<p style="font-size: 90%; color: #777777;">Upload the project image</p>';
    if (strlen($proj_image) > 0) {
        echo '<img src="' . esc_url($proj_image) . '" style="width: 500px; border: 1px solid #999999;">';
    }
    echo '</td>';
    echo '</tr>';

    // 2.project description field
    echo '<tr>';
    echo '<td style="vertical-align: top; background: #f6f6f6; padding: 5px 10px;">';
    echo '<label for="proj-website">' . __('Project Description', 'your-textdomain') . '</label>&nbsp;';
    echo '</td>';
    echo '<td>';
    $proj_desc = get_post_meta($post->ID, '_proj-desc', true);
    echo '<textarea name="proj-desc" id="proj-desc" cols="50" rows="3" placeholder="Your project description here..." style="width:100%;" maxlength="200">' . esc_html($proj_desc) . '</textarea>';
    echo '</td>';
    echo '</tr>';

    // 3.number of days to spend on the project field
    echo '<tr>';
    echo '<td style="vertical-align: top; background: #f6f6f6; padding: 5px 10px;">';
    echo '<label for="proj-days">' . __('Time spent on the project', 'your-textdomain') . '</label>&nbsp;';
    echo '</td>';
    echo '<td>';
    $proj_days = get_post_meta($post->ID, '_proj-days', true);
    if (strlen($proj_days) == 0) {
        $proj_days = 1;
    }
    echo '<input type="number" name="proj-days" id="proj-days" min="1" value="' . esc_html($proj_days) . '">' . ' ' . __('days', 'your-textdomain');
    echo '</td>';
    echo '</tr>';

    // 4.project website field
    echo '<tr>';
    echo '<td style="vertical-align: top; background: #f6f6f6; padding: 5px 10px;">';
    echo '<label for="proj-website">' . __('Website', 'your-textdomain') . '</label>&nbsp;';
    echo '</td>';
    echo '<td>';
    $proj_website = get_post_meta($post->ID, '_proj-website', true);
    echo '<input type="url" name="proj-website" id="proj-website" value="' . esc_url($proj_website) . '" style="width:100%;">';
    echo '</td>';
    echo '</tr>';

    // 4.project published date field
    echo '<tr>';
    echo '<td style="vertical-align: top; background: #f6f6f6; padding: 5px 10px;">';
    echo '<label for="proj-published">' . __('Published date', 'your-textdomain') . '</label>&nbsp;';
    echo '</td>';
    echo '<td>';
    $proj_published = get_post_meta($post->ID, '_proj-published', true);
    echo '<input type="date" name="proj-published" id="proj-published" value="' . esc_html($proj_published) . '">';
    echo '</td>';
    echo '</tr>';

    echo '</table>';
}



/**
 * Save meta box content.
 *
 * @param int $post_id Post ID
 */
function wpar_save_meta_box($post_id)
{
    /** 
     * # security check
     * 
     * We need to verify this came from the our screen and with proper authorization, 
     * because save_post can be triggered at other times.  
     * 
     * Don't forget to include nonce checks!
     */

    // Check if our nonce is set.
    if (!isset($_POST['wpar_project_nonce'])) {
        return $post_id;
    }

    $nonce = $_POST['wpar_project_nonce'];

    // Verify that the nonce is valid.
    if (!wp_verify_nonce($nonce, basename(__FILE__))) {
        return $post_id;
    }


    // If this is an autosave, our form has not been submitted,
    // so we don't want to do anything.    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return $post_id;
    }

    // Check the user's permissions.
    if ('mms_project_cpt' == $_POST['post_type']) {
        if (!current_user_can('edit_page', $post_id)) {
            return $post_id;
        }
    } else {
        if (!current_user_can('edit_post', $post_id)) {
            return $post_id;
        }
    }


    // # check data validation
    // https://developer.wordpress.org/themes/theme-security/data-validation/
    // https://jqueryvalidation.org/
    // I use the HTML attributes to do the data validation at the HTML tags which works for the modern browsers. 
    // For the old browser, the data validation may not work.
    // So you can integrate the jquery validation or ajax validation to do the data validation instead.


    // # Now, our data is safe for saving to the database
    // ## Sanitize the user input.
    // https://developer.wordpress.org/reference/functions/sanitize_text_field/
    $title = sanitize_text_field($_POST['title']);
    $proj_image = esc_url_raw($_POST['proj-image']);
    $proj_desc = sanitize_text_field($_POST['proj-desc']);
    $proj_days = sanitize_text_field($_POST['proj-days']);
    $proj_website = esc_url_raw($_POST['proj-website']);
    $proj_published = sanitize_text_field($_POST['proj-published']);


    // ## Update the meta field.
    // https://developer.wordpress.org/reference/functions/update_post_meta/
    // If the meta field never been saved to the wp_postmeta table before,
    // update_post_meta function will save the meta field for you.
    update_post_meta($post_id, 'title', $title);
    update_post_meta($post_id, '_proj-image', $proj_image);
    update_post_meta($post_id, '_proj-desc', $proj_desc);
    update_post_meta($post_id, '_proj-days', $proj_days);
    update_post_meta($post_id, '_proj-website', $proj_website);
    update_post_meta($post_id, '_proj-published', $proj_published);


    // ## Delete the meta field
    // The meta field value will stay with the post ID until the post is deleted permanently.
    // You don't need to delete the meta field manaully.
}
// https://developer.wordpress.org/reference/hooks/save_post/
add_action('save_post', 'wpar_save_meta_box');
